//OHSAT GAMES MEGATILER TUTORIAL - Levels - https://www.ohsat.com/tutorial/megatiler/megatiler-7/
//MEGATEAMWORK Makes the MEGADREAM Work 
//SGDK Version: 2.0 

//https://www.ohsat.com/tutorial/#mega-drive-tutorials 

#include <genesis.h>
#include <resources.h>
 
//array defines for tile usage 

#define SOLID_TILE 1    // barrier tile
#define SPAWN_TILE 4    //value for player sprite for use in array
#define EXIT_TILE 5     //value for door tile
#define COIN_TILE 6     //value for coin sprite

#define MAX_COINS 3     //max number of coins on the map
#define LEVEL_NUM 3     //max number of levels
//tile measurement defines

#define TILESIZE 8      // pixel value tile size
#define MAP_WIDTH 8     // tile width
#define MAP_HEIGHT 8    // tile height

//Sprite animation defines

#define ANIM_DOWN 0
#define ANIM_UP 1
#define ANIM_SIDE 2

//defines for SFX

#define SFX_COIN 64
#define SFX_UNLOCK 65

//Structs & Type  Definitions

typedef u8 map[MAP_HEIGHT][MAP_WIDTH];

typedef struct {
    u8 x;
    u8 y;
} Point;

typedef enum { up, down, left, right, none } moveDirection;

typedef struct {
    Point pos;
    Point tilePos;
    int w;
    int h;
    int health;
    bool moving;
    moveDirection dir;
    Sprite *sprite;
    char name[6];
} Entity;

typedef struct {
    Point pos;
    u8 w;
    u8 h;
    Sprite *sprite;
    u8 health;
} Coin;

// Levels

map level1 = {
    {6,0,0,0,0,0,0,6},
    {0,0,0,0,0,0,0,0},
    {0,0,0,0,1,0,0,0},
    {0,0,0,1,1,0,0,0},
    {4,0,0,0,1,0,0,0},
    {0,0,0,0,1,0,0,0},
    {0,0,0,0,1,0,0,0},
    {5,0,0,0,0,0,0,6}
};

map level2 = {
    {0,0,0,6,0,0,0,0},
    {0,0,0,0,0,0,0,0},
    {0,4,0,1,1,1,0,0},
    {0,0,0,6,0,1,0,0},
    {0,0,0,1,1,1,6,0},
    {0,0,0,1,0,0,0,0},
    {0,0,0,1,1,1,5,0},
    {0,0,0,0,0,0,0,0}
};

map level3 = {
    {0,0,0,0,0,0,0,0},
    {0,0,1,1,1,1,0,0},
    {0,0,0,0,6,1,0,0},
    {0,0,0,1,1,1,6,0},
    {0,0,0,0,0,1,0,0},
    {0,6,1,1,1,1,0,0},
    {0,4,0,0,0,0,5,0},
    {0,0,0,0,0,0,0,0}
};

//Globals

u8 x = 0;
u8 y = 0;
u8 t = 0;
u8 i = 0;

u8 coinNum = 0;
u8 coinsCollected = 0;

/*map* currentLevel;
map* levelList[LEVEL_NUM] = {&level1, &level2, &level3};
static u8 currentLevelIndex = 0; */

//OHSAT method

u8* currentLevel;
static u8 currentLevelIndex = 0;
map* levelList[3];

char hud_string[10] = "";

Point exitLocation = {0,0};
bool exitUnlocked = FALSE;

Entity player = {{0,0},{0,0},8,8,0,FALSE,none,NULL,"PLAYER"};

Coin coins[MAX_COINS];
Coin *coinToCheck;
Coin *c = coins;


int getTileAt(u8 X, u8 Y);

void loadLevel();
void movePlayer(moveDirection Direction);
void myJoyHandler(u16 joy, u16 changed, u16 state);
void updateScoreDisplay();
void unlockExit();
void clearLevel();

int main()
{   
    //MUSIC
    
    //SFX
    XGM_setPCM(SFX_COIN, sfx_coin, sizeof(sfx_coin));
    XGM_setPCM(SFX_UNLOCK, sfx_unlock, sizeof(sfx_unlock));

    JOY_init();
    JOY_setEventHandler(&myJoyHandler);
    levelList[0] = level1;
    levelList[1] = level2;
    levelList[2] = level3;
    loadLevel();
    updateScoreDisplay();
   
    while(1)
    {
        if(player.moving == TRUE){
        switch(player.dir){
            case up:
                player.pos.y -= 1;
                break;

            case down: 
                player.pos.y += 1;
                break;

            case left: 
                player.pos.x -= 1;
                break;

            case right: 
                player.pos.x += 1;
                break;

                break;
            default:
                break;
            }
        }

        SPR_update(); 

        if (player.pos.x % TILESIZE == 0 && player.pos.y % TILESIZE == 0)
        {
            player.moving = FALSE;
            //check if player on exit tile
            if (exitUnlocked == TRUE
            && player.tilePos.x == exitLocation.x
            && player.tilePos.y == exitLocation.y
        )
            {
                /* do stuff: coming in final tutorial */
                if (exitUnlocked == TRUE && player.tilePos.x == exitLocation.x && player.tilePos.y == exitLocation.y)
                    {
                        currentLevelIndex++;
                        if(currentLevelIndex >= LEVEL_NUM){
                            currentLevelIndex = 0;
                        }
                        loadLevel();
                    }
            }
            
        }
        
        SPR_setPosition(player.sprite, player.pos.x, player.pos.y);

        for (i = 0; i < MAX_COINS; i++)
        {
            coinToCheck = &coins[i];
            if ((player.pos.x < coinToCheck->pos.x + coinToCheck->w 
                && player.pos.x + player.w > coinToCheck->pos.x 
                && player.pos.y <   coinToCheck->pos.y + coinToCheck->h 
                && player.pos.y + player.h > coinToCheck->pos.y) == TRUE)
            {
                if (coinToCheck->health >0)
                {
                    coinToCheck->health = 0;
                    SPR_setVisibility(coinToCheck->sprite, HIDDEN);
                    coinsCollected++;
                    XGM_startPlayPCM(SFX_COIN, 1, SOUND_PCM_CH2);
                    updateScoreDisplay();
                    if(coinsCollected == MAX_COINS){
                        unlockExit();
                    }

                }
                
            }
        }

        SYS_doVBlankProcess();
    }

    return 0;
}


int getTileAt(u8 X, u8 Y)
{
    
    return *(currentLevel + (Y * MAP_WIDTH + X));
}

void loadLevel()
{
    clearLevel();

    //suggest fix start

    x = 0;
    y = 0; 
    coinNum = 0;
    
    //end suggested fix. 

    currentLevel = levelList[currentLevelIndex];
    SPR_init();

        u8 i = 0;
        u8 total = MAP_HEIGHT * MAP_WIDTH;
    
        for (i = 0; i < total; i++) {
        t = *(currentLevel + i);

            if (t == SPAWN_TILE)
            {
                player.tilePos.x = x;
                player.tilePos.y = y;

                player.pos.x = x * TILESIZE;
                player.pos.y = y * TILESIZE;

                player.sprite = SPR_addSprite(&spr_player, player.pos.x, player.pos.y, TILE_ATTR(PAL2, 0, FALSE, FALSE));

                VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, FALSE, FALSE, 1), x, y);
            }
            else if (t == COIN_TILE)
            {
                if (coinNum < MAX_COINS)
                {
                    c = &coins[coinNum];
                    c->pos.x = x * TILESIZE;
                    c->pos.y = y * TILESIZE;
                    c->w = 8;
                    c->h = 8;
                    c->health = 1;
                    c->sprite = SPR_addSprite(&coin, c->pos.x, c->pos.y, TILE_ATTR(PAL2, 0, FALSE, FALSE));
                    coinNum++;

                    VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, FALSE, FALSE, 1), x, y);
                }
                
            }
            
            else if (t == EXIT_TILE)
            {
                exitLocation.x = x;
                exitLocation.y = y;
                VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, FALSE, FALSE, 1), x, y);
            }

            else {
                VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, FALSE, FALSE, t + 1), x, y);
            }

        x++;
        if (x >= MAP_WIDTH)
        {
            x = 0;
            y++;
        }
        }
    


    VDP_loadTileSet(floortiles.tileset, 1, DMA);
    PAL_setPalette(PAL1, floortiles.palette->data, DMA);
    PAL_setPalette(PAL2, spr_player.palette->data, DMA);
}

void movePlayer(moveDirection Direction)
{
    if (!player.moving)
    {
        switch(Direction)
        {
            case up:
                if (player.tilePos.y > 0 &&
                    getTileAt(player.tilePos.x, player.tilePos.y - 1) != SOLID_TILE)
                {
                    player.tilePos.y--;
                    player.moving = TRUE;
                    player.dir = Direction;
                    SPR_setAnim(player.sprite, ANIM_UP);
                }
                break;

            case down:
                if (player.tilePos.y < MAP_HEIGHT - 1 &&
                    getTileAt(player.tilePos.x, player.tilePos.y + 1) != SOLID_TILE)
                {
                    player.tilePos.y++;
                    player.moving = TRUE;
                    player.dir = Direction;
                    SPR_setAnim(player.sprite, ANIM_DOWN);
                }
                break;

            case left:
                if (player.tilePos.x > 0 &&
                    getTileAt(player.tilePos.x - 1, player.tilePos.y) != SOLID_TILE)
                {
                    player.tilePos.x--;
                    player.moving = TRUE;
                    player.dir = Direction;
                    SPR_setAnim(player.sprite, ANIM_SIDE);
                    SPR_setHFlip(player.sprite, TRUE);
                }
                break;

            case right:
                if (player.tilePos.x < MAP_WIDTH - 1 &&
                    getTileAt(player.tilePos.x + 1, player.tilePos.y) != SOLID_TILE)
                {
                    player.tilePos.x++;
                    player.moving = TRUE;
                    player.dir = Direction;
                    SPR_setAnim(player.sprite, ANIM_SIDE);
                    SPR_setHFlip(player.sprite,FALSE);
                }
                break;

            default:
                break;
        }
    }
}

void myJoyHandler(u16 joy, u16 changed, u16 state)
{
    if (joy == JOY_1)
    {
        if (state & BUTTON_UP)
            movePlayer(up);
        else if (state & BUTTON_DOWN)
            movePlayer(down);
        else if (state & BUTTON_LEFT)
            movePlayer(left);
        else if (state & BUTTON_RIGHT)
            movePlayer(right);
    }
}

void updateScoreDisplay(){
    sprintf(hud_string, "SCORE: %d", coinsCollected);
    VDP_clearText(8, 0, 10);
    VDP_drawText(hud_string, 8, 0);
}

void unlockExit()
{
    exitUnlocked = TRUE;
    VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, FALSE, FALSE, FALSE, 3), exitLocation.x, exitLocation.y);
    XGM_startPlayPCM(SFX_UNLOCK, 1, SOUND_PCM_CH2);
}

void clearLevel()
{
    VDP_clearPlane(BG_B, TRUE);
    VDP_clearSprites();

    coinsCollected = 0;
    exitUnlocked = FALSE;
}

////////////////////NOTES////////////////////

/*

This is a reattempt of MEGATILER Lesson 07 - Levels to keep the code closer to 
what it is in Andrej's/OHSAT Games tutorial. 

See error handling section regarding an issue that I had that was similar to one
that was mentioned in the comments sections of the page. 

Cheers!

*/

/////////EXPERIMENTATION IDEAS///////////////

/*

1. I'm thinking of making some simple assets to make this into a Chip's Challenge kind of game. 
2. I may expand the map size to better incorporate a second player. We'll see what happens. 

*/

///////////ERROR HANDLING////////////////////

/*

Here is a retry of MEGATILER 07. This code is more in-line with what you would see if you followed 
the OHSAT lesson. However, I encountered the same issue as Pyxel Pub did in the comments. 

I wanted to leave this code intact so you could see if you get the same issue(s) when compiling.
Below is the post Pyxel Pub made in the comments section.  

Pyxel Pub  Ando (Ohsat Games)
4 years ago
Collisions with coins work as you would expect, but the other collisions including the exit are one off after the first level.

I even copied your level 2 and 3 to make sure the arrays are the same size and the same issue persisted.

I'll send you the main.c to make it easier for you to see the discrepancy, coz I sure can't find it for the life of me.

Here's the suggested fix for the issue. 

✅ THE FIX

You must reset all per-level counters at the start of loadLevel():

Add this at the top of loadLevel():
void loadLevel()
{
    clearLevel();

    x = 0;
    y = 0;
    coinNum = 0;

    currentLevel = levelList[currentLevelIndex];
    SPR_init();

❗ Why this fixes the issue
1. x and y OUT OF CONTROL

Your level loader increments:

x++;
if (x >= MAP_WIDTH) { x = 0; y++; }


But since x and y are global, when you load level 2 or 3 they start at whatever values were left from the previous load (often x=0,y=8).
This makes the tile loop write outside the tilemap and corrupt memory.

2. coinNum never resets

You increment coins:

coinNum++;


But you never reset it.
So level 2 will try to fill coins[3], coins[4], etc — outside the coins array.

This causes sprite corruption, invisible coins, crashes, or broken collision detection.

Note: Adding this fix resolved the issue. 


*/